/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.util.LogoPreviewPanel;
import DE.siemens.ad.logo.util.StandardColorChooserPanel;
import java.awt.Color;
import javax.swing.JColorChooser;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.colorchooser.DefaultColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LogoColorChooser
extends JColorChooser
implements ChangeListener {
    private LogoPreviewPanel flogoPreviewPanel = null;

    public LogoColorChooser() {
        this.initialize();
    }

    public LogoColorChooser(Color initialColor) {
        super(initialColor);
        this.initialize();
    }

    public LogoColorChooser(ColorSelectionModel model) {
        super(model);
        this.initialize();
    }

    private void handleException(Throwable exception) {
    }

    private void initialize() {
        this.setSelectionModel(new SelectionModel());
        try {
            this.addChooserPanel(new StandardColorChooserPanel());
            this.getSelectionModel().addChangeListener(this);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void setLogoPreviewPanel(LogoPreviewPanel lPP) {
        this.flogoPreviewPanel = lPP;
        if (lPP != null) {
            this.getSelectionModel().setSelectedColor(lPP.getColor());
            this.setPreviewPanel(lPP.getBorderPreview());
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (this.flogoPreviewPanel != null) {
            this.flogoPreviewPanel.stateChanged(e);
        }
    }

    private class SelectionModel
    extends DefaultColorSelectionModel {
        private SelectionModel() {
        }

        protected void fireStateChanged() {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = 0; i <= listeners.length - 2; i += 2) {
                if (listeners[i] != ChangeListener.class) continue;
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
            }
        }
    }
}

